function getAllLinksWithIFrames() {
    const links = [];
    
    function extractLinks(doc) {
        try {
            doc.querySelectorAll('a[href]').forEach(a => {
                if (a.href) links.push(a.href);
            });
            
            doc.querySelectorAll('area[href]').forEach(area => {
                if (area.href) links.push(area.href);
            });
            
            doc.querySelectorAll('frame').forEach(frame => {
                try {
                    if (frame.contentDocument) {
                        extractLinks(frame.contentDocument);
                    }
                } catch (e) {
                    // Cross-origin frame - cannot access
                }
            });
            
            doc.querySelectorAll('iframe').forEach(iframe => {
                try {
                    if (iframe.contentDocument) {
                        extractLinks(iframe.contentDocument);
                    }
                } catch (e) {
                }
            });
        } catch (e) {
        }
    }
    
    extractLinks(document);
    return links;
}
getAllLinksWithIFrames();
